/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.graphics.GLWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Objects;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class TextRenderType
extends RenderType {
    private static final Int2ObjectMap<TextRenderType> TYPES = new Int2ObjectLinkedOpenHashMap();
    private static final Int2ObjectMap<TextRenderType> SEE_THROUGH_TYPES = new Int2ObjectLinkedOpenHashMap();
    private static final ImmutableList<RenderState> GENERAL_STATES = ImmutableList.of((Object)RenderState.field_228515_g_, (Object)RenderState.field_228533_y_, (Object)RenderState.field_228519_k_, (Object)RenderState.field_228517_i_, (Object)RenderState.field_228494_D_, (Object)RenderState.field_228534_z_, (Object)RenderState.field_228528_t_, (Object)RenderState.field_228531_w_, (Object)RenderState.field_228502_L_, (Object)RenderState.field_228498_H_, (Object)RenderState.field_228504_N_, (Object)RenderState.field_228524_p_, (Object[])new RenderState[]{RenderState.field_228495_E_, RenderState.field_228506_P_});
    private static final ImmutableList<RenderState> SEE_THROUGH_STATES = ImmutableList.of((Object)RenderState.field_228515_g_, (Object)RenderState.field_228533_y_, (Object)RenderState.field_228519_k_, (Object)RenderState.field_228517_i_, (Object)RenderState.field_228492_B_, (Object)RenderState.field_228534_z_, (Object)RenderState.field_228528_t_, (Object)RenderState.field_228531_w_, (Object)RenderState.field_228502_L_, (Object)RenderState.field_228498_H_, (Object)RenderState.field_228504_N_, (Object)RenderState.field_228524_p_, (Object[])new RenderState[]{RenderState.field_228496_F_, RenderState.field_228506_P_});
    private final int hashCode;
    public final int textureName;

    private TextRenderType(int textureName) {
        super("modern_text", DefaultVertexFormats.field_227852_q_, 7, 256, false, true, () -> {
            GENERAL_STATES.forEach(RenderState::func_228547_a_);
            RenderSystem.enableTexture();
            RenderSystem.bindTexture((int)textureName);
        }, () -> GENERAL_STATES.forEach(RenderState::func_228549_b_));
        this.textureName = textureName;
        this.hashCode = Objects.hash(super.hashCode(), GENERAL_STATES, textureName);
    }

    private TextRenderType(int textureName, String t) {
        super(t, DefaultVertexFormats.field_227852_q_, 7, 256, false, true, () -> {
            SEE_THROUGH_STATES.forEach(RenderState::func_228547_a_);
            RenderSystem.enableTexture();
            RenderSystem.bindTexture((int)textureName);
        }, () -> SEE_THROUGH_STATES.forEach(RenderState::func_228549_b_));
        this.textureName = textureName;
        this.hashCode = Objects.hash(super.hashCode(), SEE_THROUGH_STATES, textureName);
    }

    public static TextRenderType getOrCacheType(int textureName, boolean seeThrough) {
        if (seeThrough) {
            return (TextRenderType)((Object)SEE_THROUGH_TYPES.computeIfAbsent(textureName, n -> new TextRenderType(n, "modern_text_see_through")));
        }
        return (TextRenderType)((Object)TYPES.computeIfAbsent(textureName, TextRenderType::new));
    }

    public static void deleteTextures() {
        for (Int2ObjectMap.Entry entry : TYPES.int2ObjectEntrySet()) {
            GLWrapper.deleteTexture(3553, entry.getIntKey());
        }
        TYPES.clear();
        SEE_THROUGH_TYPES.clear();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

